/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.ibex.nestedvm.Runtime;

class AtariCanvas
extends Canvas
implements KeyListener {
    byte[] pixels;
    MemoryImageSource mis;
    IndexColorModel icm;
    Image image;
    int atari_width;
    int atari_height;
    int atari_visible_width;
    int atari_left_margin;
    int width;
    int height;
    int scalew;
    int scaleh;
    int size;
    boolean windowClosed = false;
    Vector keyqueue;
    Hashtable kbhits;
    byte[][] paletteTable;
    byte[] temp;
    BufferedImage bum;
    boolean palFilter = false;
    int off = 0;
    int lastPix = 0;
    int[] imagepixels;
    boolean uneven = false;
    int o;
    int p;
    WritableRaster raster;
    Graphics d;
    int ts = 0;
    boolean RGB;

    AtariCanvas() {
    }

    @Override
    public void paint(Graphics g2) {
        this.update(g2);
    }

    public void doPALFilter() {
        this.off = 0;
        while (this.off < this.imagepixels.length) {
            this.lastPix = this.imagepixels[this.off] = (this.lastPix & 0xFEFEFE) + (this.imagepixels[this.off] & 0xFEFEFE) >> 1;
            ++this.off;
        }
        for (int x = 0; x < this.width * this.scalew; ++x) {
            this.off = x;
            for (int y = 0; y < this.height * this.scaleh; y += 2) {
                this.imagepixels[this.off + this.width * this.scalew] = (this.imagepixels[this.off] & 0xFEFEFE) >> 1;
                this.off += this.width * this.scalew * 2;
            }
        }
    }

    @Override
    public void update(Graphics g2) {
        if (this.palFilter) {
            if (this.bum == null) {
                this.bum = new BufferedImage(this.width * this.scalew, this.height * this.scaleh, 1);
                this.imagepixels = new int[this.width * this.scalew * this.height * this.scaleh];
                this.o = this.width * this.scalew;
                this.p = this.height * this.scaleh;
                this.raster = this.bum.getRaster();
                this.d = this.bum.createGraphics();
            }
            this.d.drawImage(this.image, 0, 0, this.o, this.p, null);
            this.raster.getDataElements(0, 0, this.o, this.p, this.imagepixels);
            if (this.RGB) {
                this.off = 0;
                this.uneven = false;
                this.ts = 0;
                block5: for (int i2 = 0; i2 < this.imagepixels.length; ++i2) {
                    ++this.off;
                    if (this.off == this.o) {
                        this.ts = this.uneven ? 2 : 0;
                        this.uneven = !this.uneven;
                        this.off = 0;
                    }
                    ++this.ts;
                    if (this.ts > 3) {
                        this.ts = 0;
                    }
                    switch (this.ts) {
                        case 0: {
                            int n2 = i2;
                            this.imagepixels[n2] = this.imagepixels[n2] & 0xFF0000;
                            continue block5;
                        }
                        case 1: {
                            int n3 = i2;
                            this.imagepixels[n3] = this.imagepixels[n3] & 0xFF00;
                            continue block5;
                        }
                        case 2: {
                            int n4 = i2;
                            this.imagepixels[n4] = this.imagepixels[n4] & 0xFF;
                        }
                    }
                }
            } else {
                this.doPALFilter();
            }
            this.raster.setDataElements(0, 0, this.o, this.p, this.imagepixels);
            this.bum.setData(this.raster);
            g2.drawImage(this.bum, 0, 0, this.o, this.p, null);
        } else {
            g2.drawImage(this.image, 0, 0, this.width * this.scalew, this.height * this.scaleh, null);
        }
    }

    public void writeScreen() {
        this.imagepixels = new int[this.width * this.scalew * this.height * this.scaleh];
        this.o = this.width * this.scalew;
        this.p = this.height * this.scaleh;
        this.bum = new BufferedImage(this.width * this.scalew, this.height * this.scaleh, 1);
        this.raster = this.bum.getRaster();
        this.d = this.bum.createGraphics();
        this.d = this.bum.createGraphics();
        this.d.drawImage(this.image, 0, 0, this.o, this.p, null);
        if (this.palFilter) {
            this.raster.getDataElements(0, 0, this.o, this.p, this.imagepixels);
            if (this.RGB) {
                this.off = 0;
                this.uneven = false;
                this.ts = 0;
                block7: for (int i2 = 0; i2 < this.imagepixels.length; ++i2) {
                    ++this.off;
                    if (this.off == this.o) {
                        this.ts = this.uneven ? 2 : 0;
                        this.uneven = !this.uneven;
                        this.off = 0;
                    }
                    ++this.ts;
                    if (this.ts > 3) {
                        this.ts = 0;
                    }
                    switch (this.ts) {
                        case 0: {
                            int n2 = i2;
                            this.imagepixels[n2] = this.imagepixels[n2] & 0xFF0000;
                            continue block7;
                        }
                        case 1: {
                            int n3 = i2;
                            this.imagepixels[n3] = this.imagepixels[n3] & 0xFF00;
                            continue block7;
                        }
                        case 2: {
                            int n4 = i2;
                            this.imagepixels[n4] = this.imagepixels[n4] & 0xFF;
                        }
                    }
                }
            } else {
                this.doPALFilter();
            }
            this.raster.setDataElements(0, 0, this.o, this.p, this.imagepixels);
            this.bum.setData(this.raster);
        }
        int pos = 0;
        String b2 = "";
        if (pos < 10) {
            b2 = b2 + "0";
        }
        if (pos < 100) {
            b2 = b2 + "0";
        }
        File fil = new File("atari" + b2 + pos + ".png");
        while (fil.exists()) {
            b2 = "";
            if (++pos < 10) {
                b2 = b2 + "0";
            }
            if (pos < 100) {
                b2 = b2 + "0";
            }
            fil = new File("atari" + b2 + pos + ".png");
        }
        try {
            ImageIO.write((RenderedImage)this.bum, "png", fil);
        }
        catch (Exception e2) {
            System.out.println("Error writing " + fil.getName());
        }
        this.requestFocus();
    }

    public void init() {
        this.width = this.atari_visible_width;
        this.temp = new byte[this.width];
        this.height = this.atari_height;
        this.size = this.width * this.height;
        this.pixels = new byte[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.pixels[i2] = 0;
        }
        this.keyqueue = new Vector();
        this.addKeyListener(this);
        this.kbhits = new Hashtable();
    }

    public void initPalette(Runtime rt, int colortable) {
        this.paletteTable = new byte[3][256];
        int entry = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            try {
                entry = rt.memRead(colortable + i2 * 4);
            }
            catch (Exception e2) {
                System.err.println(e2);
            }
            this.paletteTable[0][i2] = (byte)(entry >>> 16 & 0xFF);
            this.paletteTable[1][i2] = (byte)(entry >>> 8 & 0xFF);
            this.paletteTable[2][i2] = (byte)(entry & 0xFF);
        }
        this.paletteTable[0][0] = 0;
        this.paletteTable[1][0] = 0;
        this.paletteTable[2][0] = 0;
        this.icm = new IndexColorModel(8, 256, this.paletteTable[0], this.paletteTable[1], this.paletteTable[2]);
        this.mis = new MemoryImageSource(this.width, this.height, (ColorModel)this.icm, this.pixels, 0, this.width);
        this.mis.setAnimated(true);
        this.mis.setFullBufferUpdates(true);
        this.image = this.createImage(this.mis);
    }

    public void displayScreen(Runtime rt, int atari_screen) {
        int ao = atari_screen + this.atari_left_margin;
        int po = 0;
        for (int h2 = 0; h2 < 240; ++h2) {
            try {
                rt.copyin(ao, this.temp, this.width);
                System.arraycopy(this.temp, 0, this.pixels, po, this.width);
            }
            catch (Exception e2) {
                // empty catch block
            }
            ao += this.atari_width;
            po += this.width;
        }
        this.mis.newPixels();
        this.repaint();
    }

    public void setWindowClosed() {
        this.windowClosed = true;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        char chr = event.getKeyChar();
        int key = event.getKeyCode();
        int loc = event.getKeyLocation();
        if (key == 120) {
            return;
        }
        if (key == 121) {
            return;
        }
        this.keyqueue.addElement(event);
        Integer[] val = new Integer[]{new Integer(key), new Integer(loc)};
        this.kbhits.put(Arrays.asList(val), new Boolean(true));
    }

    @Override
    public void keyReleased(KeyEvent event) {
        char chr = event.getKeyChar();
        int key = event.getKeyCode();
        if (key == 120) {
            try {
                System.exit(0);
                return;
            }
            catch (Exception e2) {
                return;
            }
        }
        if (key == 121) {
            this.writeScreen();
            return;
        }
        if (key == 123) {
            this.palFilter = false;
            this.repaint();
        }
        if (key == 122) {
            this.RGB = !this.RGB;
            this.palFilter = true;
            this.repaint();
        }
        int loc = event.getKeyLocation();
        this.keyqueue.addElement(event);
        Integer[] val = new Integer[]{new Integer(key), new Integer(loc)};
        this.kbhits.remove(Arrays.asList(val));
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    int getKbhits(int key, int loc) {
        Integer[] val = new Integer[]{new Integer(key), new Integer(loc)};
        if (this.kbhits.get(Arrays.asList(val)) != null) {
            return 1;
        }
        return 0;
    }

    int pollKeyEvent(Runtime rt, int return_event) {
        if (this.keyqueue.isEmpty()) {
            return 0;
        }
        KeyEvent event = (KeyEvent)this.keyqueue.firstElement();
        this.keyqueue.removeElement(event);
        int type = event.getID();
        int key = event.getKeyCode();
        char uni = event.getKeyChar();
        int loc = event.getKeyLocation();
        try {
            rt.memWrite(return_event + 0, type);
            rt.memWrite(return_event + 4, key);
            rt.memWrite(return_event + 8, uni);
            rt.memWrite(return_event + 12, loc);
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
        return 1;
    }

    int getWindowClosed() {
        return this.windowClosed ? 1 : 0;
    }
}

